/*
 * httpserv.cpp
 *
 *  Created on: 23.04.2009
 *      Author: Ralf Schler
 */
#include <QtCore>
#include <QtNetwork>
#include "tcpserver.h"
#include "samplewidget.h"

 TcpDaemon::TcpDaemon( QObject* parent) :
QTcpServer(parent)
{
     // eine neu reinkommende Verbindung mge in slotNewConnection abgehandelt werden
     connect(this, SIGNAL(newConnection()),this, SLOT(slotNewConnection()));
     // wir horchen an Port 32032 auf Verbindungen
     listen(QHostAddress::Any,32032);


}

void TcpDaemon::slotNewConnection()
{
    // gib mit die ausstehende Verbindung
    QTcpSocket *con=nextPendingConnection();
    // beim disconnect aus der internen Liste rauswerfen
    connect(con, SIGNAL(disconnected ()),this,SLOT(discardClient()));
    // wenn Daten reinkommen, readClient aufrufen
    connect(con, SIGNAL(readyRead ()),this,SLOT(readClient()));
    // wir speichern eine interne Liste aller aktuellen Verbindungen
    conList.append(con);

    // jetzt schicken wir eine kurze Begrungsnachricht zurck
    QTextStream os( con );
    os.setCodec("UTF-8");
    os << QString("Willkommen\r\n").toAscii().data();
}

void TcpDaemon::readClient()
{
    // in irgendeiner Verbindung stehen Daten bereit
    int i;
    for(i=0;i<conList.count();i++){
        while(conList[i]->canReadLine()){ // wir wollen nur ganze Zeilen haben
            // wir leiten an die Parse Funktion weiter;
            // dazu ist ein etwas umstndlicher Typecast des parent-Zeigers notwendig
            int result=((SampleWidget*)parent())->Parse(conList[i]->readLine());
            // und jetzt geben wir als Antwort noch den Fehlercode zurck
            QTextStream os( conList[i] );
            os.setCodec("UTF-8");
            os << QString("Result: %1\r\n").arg(result).toUtf8().data();
        }//while
    }
}


void TcpDaemon::discardClient()
{
	int i;
    for(i=0;i<conList.count();i++){
        //alle nicht (mehr) verbundenen Objekte aus der Verbindungsliste entfernen
		if(conList[i]->state()!=QAbstractSocket::ConnectedState){
            // wir berlassen das Lschen Qt
            conList.takeAt(i)->deleteLater();
            conList.removeAt(i);
			break;
		}
	}
}

