#include <QtCore>
#include <QtGui>
#include "samplewidget.h"
#include "ui_samplewidget.h"

SampleWidget::SampleWidget(QWidget *parent)
    : QWidget(parent)
{
    setupUi(this);
    tcpDaemon=new TcpDaemon(this);
}

SampleWidget::~SampleWidget()
{
    delete tcpDaemon;
}

void SampleWidget::on_setButton_clicked()
{
    on_lineEdit_returnPressed();
}

void SampleWidget::on_lineEdit_returnPressed()
{
    int error=Parse(lineEdit->text());

    //wenn Parse einen Fehler zurckgibt, dann sagen wir das dem Nutzer
   if(error) QMessageBox::warning(this,"Fehler",QString("Beim Auswerten der Eingabe ist Fehler %1 aufgetreten.").arg(error));
   lineEdit->setText("");

}

int SampleWidget::Parse(QString s)
{
    // zuerst vereinfachen wir den String
    s=s.simplified();
    // aufsplitten an den Leerzeichen (brauchen wir nur fr "set"
    QStringList list=s.split(' ',QString::SkipEmptyParts);

    if(list.isEmpty()||list[0].isEmpty())return 10;

    if(list[0].compare("CLEAR",Qt::CaseInsensitive)==0){
        op1Label->setText("");
        op2Label->setText("");
        resultLabel->setText("");
        return 0;
    }else if(list[0].compare("SET",Qt::CaseInsensitive)==0){
        // wir brauchen noch 2 argumente
        if(list.count()!=3)return 11;
        if(list[1].compare("OP1",Qt::CaseInsensitive)==0){
            op1Label->setText(list[2]);
            return 0;
        }else if(list[1].compare("OP2",Qt::CaseInsensitive)==0){
            op2Label->setText(list[2]);
            return 0;
        }else return 2;
    }else if(list[0].compare("ADD",Qt::CaseInsensitive)==0){
        double op1,op2,result;
        bool ok=false;
        op1=op1Label->text().toDouble(&ok);
        if(!ok)return 3;
        op2=op2Label->text().toDouble(&ok);
        if(!ok)return 4;
        result=op1+op2;
        resultLabel->setText(QString("%1").arg(result));
        return 0;
    }else if(list[0].compare("MULT",Qt::CaseInsensitive)==0){
        double op1,op2,result;
        bool ok=false;
        op1=op1Label->text().toDouble(&ok);
        if(!ok)return 3;
        op2=op2Label->text().toDouble(&ok);
        if(!ok)return 4;
        result=op1*op2;
        resultLabel->setText(QString("%1").arg(result));
        return 0;
    }
    else return 1;
}
