<?php

/*
Plugin Name: NextCellent Random Image
Plugin URI: http://schueler.ws/?page_id=1215
Description: Adds a randomimage tag for selecting a random image from a NextCellent gallery; extents singlepic with a caption-template
Author: Ralf Schueler
Version: 0.1
Author URI: http://schueler.ws
*/




function randomimage( $atts ) {
extract( shortcode_atts( array(
'galleryid' => 1,
'template' => '',
'w' => 500,
'h' => '',
'float' => 'none',
'mode' => '',
'link' => ''
), $atts ) );

global $nggdb;

$picturelist = $nggdb->get_gallery($galleryid, $ngg_options['galSort'], $ngg_options['galSortDir']);
$cnt=count($picturelist);
$idx=rand(0,$cnt-1);
$img=current($picturelist);
for($i=0;$i<$idx;$i++)$img=next($picturelist);
$pid=$img->pid;
$shortcode="[singlepic w=$w id=$pid float=$float";
if(!empty($h))$shortcode=$shortcode . " h=$h";
if(!empty($template))$shortcode=$shortcode . " template=$template";
if(!empty($mode))$shortcode=$shortcode . " mode=$mode";
if(!empty($link))$shortcode=$shortcode . " link=$link";
$shortcode=$shortcode . "/]";
//echo $shortcode;
return do_shortcode($shortcode);

}


function add_template( $path, $template_name = false) {
  // echo "--".$template_name."-- <BR>";
   if ($template_name == 'singlepic-caption')
      //$path='/wp_content/' . plugin_basename( dirname(__FILE__) ) .'/'. 'singlepic-caption.php';
      $path = WP_PLUGIN_DIR . '/' .plugin_basename( dirname(__FILE__) ) .'/'. 'singlepic-caption.php';
   //echo $path.'<BR>';
   //if(file_exists($path))echo "OK"."<BR>";
   return $path;
}


function ngg_randomimage_add_admin_menu(  ) {

	add_submenu_page( 'plugins.php', 'ngg_randomimage', 'ngg_randomimage', 'manage_options', 'ngg_randomimage', 'ngg_randomimage_options_page' );

}


function ngg_randomimage_settings_init(  ) {

	register_setting( 'pluginPage', 'ngg_randomimage_settings' );

	add_settings_section(
		'ngg_randomimage_pluginPage_section',
		__('Option for the singlepic_caption and randomimage caption formatting', 'wordpress' ),
		'ngg_randomimage_settings_section_callback',
		'pluginPage'
	);

	add_settings_field(
		'ngg_randomimage_captioncode',
		__( 'Formatting of the caption', 'wordpress' ),
		'ngg_randomimage_textarea_field_0_render',
		'pluginPage',
		'ngg_randomimage_pluginPage_section'
	);


}


function ngg_randomimage_textarea_field_0_render(  ) {

	$options = get_option( 'ngg_randomimage_settings' );
	?>
	<textarea cols='40' rows='5' name='ngg_randomimage_settings[ngg_randomimage_captioncode]'>
		<?php echo $options['ngg_randomimage_captioncode']; ?>
 	</textarea>
	<?php

}


function ngg_randomimage_settings_section_callback(  ) {

	echo __(  "Enter the HTML-code to format the caption text. Use %s as the placeholder for the caption text and pay attention to close all tags.", 'wordpress' );

}


function ngg_randomimage_options_page(  ) {

	?>
	<form action='options.php' method='post'>

		<h2>ngg_randomimage</h2>

		<?php
		settings_fields( 'pluginPage' );
		do_settings_sections( 'pluginPage' );
		submit_button();
		?>

	</form>
	<?php

}


add_shortcode( 'randomimage', 'randomimage' );
add_filter('ngg_render_template','add_template', 20, 2);

add_action( 'admin_menu', 'ngg_randomimage_add_admin_menu' );
add_action( 'admin_init', 'ngg_randomimage_settings_init' );


?>
